PROGRAM_NAME='VANCO_EVMX_HDBTMatrix Switcher_Driver_Rev0'
(***********************************************************)
(***********************************************************)
(*  FILE_LAST_MODIFIED_ON: 04/05/2006  AT: 09:00:25        *)
(***********************************************************)
(* System Type : NetLinx                                   *)
(***********************************************************)
(* REV HISTORY:                                            *)
(***********************************************************)
(*
The following code and files are derivative work and are Copyright
as Open Source Code.
This file may be copied and distributed free of charge
No Warranty for any part involved in an installation of any equipment.
No Warranty for any part involved in an installation of any software 
or any part of this code.

This code package/file is a draft/preliminary only
The default law under the Copyright Act is that the author 
of the work ? the independent software developer? owns the 
copyright to the software. Moreover, a transfer of the ownership 
to the software?s copyright is only valid if it is in writing 
and signed by the author or owner of the work.
*)
(***********************************************************)
(*          DEVICE NUMBER DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_DEVICE

DEV_Switcher = 5001:1:0 ;
DEV_TP  = 10001:1:0 ;

dvMaster = 0:0:0 ;
dvIPClient = 0:3:0

(***********************************************************)
(*               CONSTANT DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_CONSTANT

TCP_IP = 1
nIPPort = 8000


SWITCHER_ChannelPowerOn_BNT 	= 80
SWITCHER_ChannelPowerOff_BNT 	= 81
SWITCHER_ChannelClear_BNT 	= 82
SWITCHER_ChannelClear_FB_BNT 	= 1


INPUT_1_BNT 		= 40
INPUT_2_BNT 		= 41
INPUT_3_BNT 		= 42
INPUT_4_BNT 		= 43
INPUT_5_BNT 		= 44
INPUT_6_BNT 		= 45
INPUT_7_BNT 		= 46
INPUT_8_BNT 		= 47
INPUT_9_BNT 		= 48
INPUT_10_BNT 		= 49
INPUT_11_BNT 		= 50
INPUT_12_BNT 		= 51
INPUT_13_BNT 		= 52
INPUT_14_BNT 		= 53
INPUT_15_BNT 		= 54
INPUT_16_BNT 		= 55

OUTPUT_1_BNT 		= 56
OUTPUT_2_BNT 		= 57
OUTPUT_3_BNT 		= 58
OUTPUT_4_BNT 		= 59
OUTPUT_5_BNT 		= 60
OUTPUT_6_BNT 		= 61
OUTPUT_7_BNT 		= 62
OUTPUT_8_BNT 		= 63
OUTPUT_9_BNT 		= 64
OUTPUT_10_BNT 		= 65
OUTPUT_11_BNT 		= 66
OUTPUT_12_BNT 		= 67
OUTPUT_13_BNT 		= 68
OUTPUT_14_BNT 		= 69
OUTPUT_15_BNT 		= 70
OUTPUT_16_BNT 		= 71


INPUT_1_FB_BNT 		= 2
INPUT_2_FB_BNT 		= 3
INPUT_3_FB_BNT 		= 4
INPUT_4_FB_BNT 		= 5
INPUT_5_FB_BNT 		= 6
INPUT_6_FB_BNT 		= 7
INPUT_7_FB_BNT 		= 8
INPUT_8_FB_BNT 		= 9
INPUT_9_FB_BNT 		= 10
INPUT_10_FB_BNT 	= 11
INPUT_11_FB_BNT 	= 12
INPUT_12_FB_BNT 	= 13
INPUT_13_FB_BNT 	= 14
INPUT_14_FB_BNT 	= 15
INPUT_15_FB_BNT 	= 16
INPUT_16_FB_BNT 	= 17


OUTPUT_1_FB_BNT 	= 18
OUTPUT_2_FB_BNT 	= 19
OUTPUT_3_FB_BNT 	= 20
OUTPUT_4_FB_BNT 	= 21
OUTPUT_5_FB_BNT 	= 22
OUTPUT_6_FB_BNT 	= 23
OUTPUT_7_FB_BNT 	= 24
OUTPUT_8_FB_BNT 	= 25
OUTPUT_9_FB_BNT 	= 26
OUTPUT_10_FB_BNT 	= 27
OUTPUT_11_FB_BNT 	= 28
OUTPUT_12_FB_BNT 	= 29
OUTPUT_13_FB_BNT 	= 30
OUTPUT_14_FB_BNT 	= 31
OUTPUT_15_FB_BNT 	= 32
OUTPUT_16_FB_BNT 	= 33


OUTPUT_1_FB 		= 1
OUTPUT_2_FB 		= 2
OUTPUT_3_FB 		= 3
OUTPUT_4_FB 		= 4
OUTPUT_5_FB 		= 5
OUTPUT_6_FB 		= 6
OUTPUT_7_FB 		= 7
OUTPUT_8_FB 		= 8
OUTPUT_9_FB 		= 9
OUTPUT_10_FB 		= 10
OUTPUT_11_FB 		= 11
OUTPUT_12_FB 		= 12
OUTPUT_13_FB 		= 13
OUTPUT_14_FB 		= 14
OUTPUT_15_FB 		= 15
OUTPUT_16_FB 		= 16

(***********************************************************)
(*              DATA TYPE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_TYPE

(***********************************************************)
(*               VARIABLE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_VARIABLE
CHAR CMDrx[55]
CHAR CMDtx[10]
CHAR CMDtx_Trash[25]
CHAR buildCMD[80]
CHAR bulidCMD_Buffer[100]
INTEGER currentDisplay[16]
INTEGER output
INTEGER input
INTEGER flagToggleOutput[16]
INTEGER flagToggleInput[16]
INTEGER intClear

INTEGER flagOutput
INTEGER flagInput
INTEGER iOutput[16]
INTEGER iInput[16]
INTEGER iCLEAR;
INTEGER output_FB[16];
INTEGER pInput;
INTEGER pOutput;

INTEGER pInput_BNT;
INTEGER pOutput_BNT;

CHAR CMDtx_Trash_TEST[100]
CHAR build_StreamTrash[25]

CHAR txBuffer[20]
CHAR sOutput[2]
CHAR sInput[2]
CHAR buildStream[240]
CHAR build_Stream[240]

CHAR buildStream_Buff[240]

INTEGER r

VOLATILE INTEGER SWITCHER_ChannelInPuts_BNTS[]=
{
INPUT_1_BNT,
INPUT_2_BNT,
INPUT_3_BNT,
INPUT_4_BNT,
INPUT_5_BNT,
INPUT_6_BNT,
INPUT_7_BNT,
INPUT_8_BNT,
INPUT_9_BNT,
INPUT_10_BNT,
INPUT_11_BNT,
INPUT_12_BNT,
INPUT_13_BNT,
INPUT_14_BNT,
INPUT_15_BNT,
INPUT_16_BNT
}
VOLATILE INTEGER SWITCHER_ChannelInPuts_FB_BNTS[]=
{
INPUT_1_FB_BNT,
INPUT_2_FB_BNT,
INPUT_3_FB_BNT,
INPUT_4_FB_BNT,
INPUT_5_FB_BNT,
INPUT_6_FB_BNT,
INPUT_7_FB_BNT,
INPUT_8_FB_BNT,
INPUT_9_FB_BNT,
INPUT_10_FB_BNT,
INPUT_11_FB_BNT,
INPUT_12_FB_BNT,
INPUT_13_FB_BNT,
INPUT_14_FB_BNT,
INPUT_15_FB_BNT,
INPUT_16_FB_BNT
}
VOLATILE INTEGER SWITCHER_ChannelOutPuts_BNTS[]=
{
OUTPUT_1_BNT,
OUTPUT_2_BNT,
OUTPUT_3_BNT,
OUTPUT_4_BNT,
OUTPUT_5_BNT,
OUTPUT_6_BNT,
OUTPUT_7_BNT,
OUTPUT_8_BNT,
OUTPUT_9_BNT,
OUTPUT_10_BNT,
OUTPUT_11_BNT,
OUTPUT_12_BNT,
OUTPUT_13_BNT,
OUTPUT_14_BNT,
OUTPUT_15_BNT,
OUTPUT_16_BNT
}
VOLATILE INTEGER SWITCHER_ChannelOutPuts_FB_BNTS[]=
{
OUTPUT_1_FB_BNT,
OUTPUT_2_FB_BNT,
OUTPUT_3_FB_BNT,
OUTPUT_4_FB_BNT,
OUTPUT_5_FB_BNT,
OUTPUT_6_FB_BNT,
OUTPUT_7_FB_BNT,
OUTPUT_8_FB_BNT,
OUTPUT_9_FB_BNT,
OUTPUT_10_FB_BNT,
OUTPUT_11_FB_BNT,
OUTPUT_12_FB_BNT,
OUTPUT_13_FB_BNT,
OUTPUT_14_FB_BNT,
OUTPUT_15_FB_BNT,
OUTPUT_16_FB_BNT
}

VOLATILE INTEGER SWITCHER_ChannelStatus_BNTS[] =
{
OUTPUT_1_FB,
OUTPUT_2_FB,
OUTPUT_3_FB,
OUTPUT_4_FB,
OUTPUT_5_FB,
OUTPUT_6_FB,
OUTPUT_7_FB,
OUTPUT_8_FB,
OUTPUT_9_FB,
OUTPUT_10_FB,
OUTPUT_11_FB,
OUTPUT_12_FB,
OUTPUT_13_FB,
OUTPUT_14_FB,
OUTPUT_15_FB,
OUTPUT_16_FB
}

(***********************************************************)
(*               LATCHING DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_LATCHING

(***********************************************************)
(*       MUTUALLY EXCLUSIVE DEFINITIONS GO BELOW           *)
(***********************************************************)
DEFINE_MUTUALLY_EXCLUSIVE

(***********************************************************)
(*        SUBROUTINE/FUNCTION DEFINITIONS GO BELOW         *)
(***********************************************************)



DEFINE_FUNCTION getCommandrx ()
{ 
INTEGER iTempOut,iTempIn;
LOCAL_VAR trash[2],trash1[2],tempIn[2],tempOut[2];

		trash = REMOVE_STRING('p',CMDrx,1);       
		tempIn = LEFT_STRING(CMDrx,2);
		trash = REMOVE_STRING('i',CMDrx,1); 
		tempOut = LEFT_STRING(CMDrx,2);

    iTempOut = AtoI(tempOut);
    iTempIn = AtoI(tempIn);

		IF(iTempOut = 0)
		{
			currentDisplay[iTempIn] =0;
			SEND_COMMAND DEV_TP ,"'^TXT-',SWITCHER_ChannelStatus_BNTS[iTempIn],',0,',currentDisplay[iTempIn]"
		}
		ELSE
		{
			currentDisplay[iTempOut] = iTempIn;
			SEND_COMMAND DEV_TP ,"'^TXT-',SWITCHER_ChannelStatus_BNTS[iTempOut],',0,',currentDisplay[iTempOut]"
		}
   CMDrx = "";
}



//remove the delimiter and send the command to switcher
DEFINE_FUNCTION setCommandtx ()
{
    LONG_WHILE(LENGTH_STRING(buildStream_Buff)> 5)
    {
	WAIT 20
	{
	    CMDtx_Trash = REMOVE_STRING(buildStream_Buff,'>',1)
	    CMDtx = LEFT_STRING(CMDtx_Trash,LENGTH_STRING(CMDtx_Trash)-1);

	    SEND_STRING DEV_Switcher,"CMDtx,$0D"
	    SEND_COMMAND DEV_TP ,"'^TXT-100',',0,',CMDtx"
	    
	    build_StreamTrash = REMOVE_STRING(build_Stream,' ',1)
	    SEND_COMMAND DEV_TP ,"'^TXT-101',',0,',build_Stream"
	    
	}
    }
    clear_buffer buildStream_Buff
    clear_buffer buildStream
    clear_buffer build_Stream
}

DEFINE_FUNCTION CHAR[250] getNumChar (INTEGER output,INTEGER input)
{
LOCAL_VAR sOutput[2],sInput[2];

	IF(output <10)
	{
		sOutput = "'0', ITOA(output)";
	}
	ELSE
	{
 	 	sOutput = ITOA(output);
	}
  	IF(input <10)
	{
		sInput = "'0', ITOA(input)";
	}
	ELSE
	{
		sInput = ITOA(input);
	}
	buildStream =  "buildStream,'P',sInput,'I',sOutput,'>'" 
	build_Stream =  "build_Stream,'P',sInput,'I',sOutput,' '"	
	Return buildStream;
}
//****
DEFINE_FUNCTION CHAR[250] getBuildStringSwitch (INTEGER output_char,INTEGER Input_char)
{
LOCAL_VAR INTEGER x;
    FOR (X=1; X<17; X++)
    {
	IF(flagToggleOutput[x])
	{
	    output_char = x;
	    getNumChar (x,Input_char);
	    flagToggleOutput[x] = 0;
	}	
    }
    FOR (X=1; X<17; X++)
    {
	flagToggleInput[x] = 0;
    }
	flagOutput = 0;
	flagInput = 0;

	bulidCMD_Buffer = buildStream;
	Return buildStream;
}

DEFINE_FUNCTION CHAR[25] getBuildStringPower(INTEGER state)
{
    IF(state =1)
    {
	buildStream = "'PON',$0D,'>'";
    }
    ELSE
    {
	buildStream = "'POFF',$0D,'>'";
    }
Return buildStream;
}

DEFINE_FUNCTION CHAR[50] setBuildStringClearOut()
{
INTEGER x;
LOCAL_VAR sOutput[2];
 
	FOR (x=1; x<17; x++)
	{
		IF(flagToggleOutput[x] =1)
		{
			IF(x <10)
			{
				sOutput = "'0', ITOA(x)";
			}
			ELSE
			{
 	 			sOutput = ITOA(x);
			}
    		flagToggleOutput[x] =0;
		flagOutput 	= 0;
		iOutput[x]  	= 0;
		output_FB[x] 	= 0;
		buildStream = "buildStream_Buff, 'P', sOutput, 'I00',$0D, '>'";
		}
	}
	Return buildStream;
}

DEFINE_FUNCTION CHAR[250] getBuildString(INTEGER cmdType,INTEGER output,INTEGER input,INTEGER state)
{
  		SWITCH(cmdType)
		{
			CASE 1://switch input command
			{
				buildStream =  getBuildStringSwitch(output,input) ;
				

				//setCommandtx ()
			}
			CASE 2://switch power command
			{
				buildStream =  getBuildStringPower(state) ;		
			}
			CASE 3 :
			{
				buildCMD = setBuildStringClearOut();
			}
		}
    Return (buildStream);
}

DEFINE_FUNCTION setFB_Input(INTEGER index)
{
 	iInput[index] = 1;
}
DEFINE_FUNCTION setFB_Output(INTEGER index)
{
 	iOutput[index] = 1;
}
 
DEFINE_FUNCTION setCommand (INTEGER cmdType ,INTEGER pOutput,INTEGER pInput)
{
    buildStream_Buff = getBuildString(cmdType,pOutput,pInput,0);
    setCommandtx ()
}
DEFINE_FUNCTION getTogleInput (INTEGER index)
{
INTEGER r,tempIndex,tempValue;

    IF(flagToggleInput[index]= 1)
    {
	tempValue =1 ;
    }
    ELSE
    tempValue =0 ;

    FOR(r= 1; r<17; r++)
    {
	flagToggleInput[r] = 0;
	iInput[r] = 0;
    }
flagToggleInput[index] = tempValue;
flagToggleInput[index] =! flagToggleInput[index];
iInput[index] = flagToggleInput[index];

	IF(flagToggleInput[index] = 0)
	{
		flagInput = 0;
	}
	ELSE
	{
	    flagInput = 1;
    }

}
DEFINE_FUNCTION getTogleOut (INTEGER index)
{
INTEGER x;

	flagToggleOutput[index] =!flagToggleOutput[index];
	iOutput[index] =! iOutput[index];

	output_FB[index] = flagToggleOutput[index];
	FOR(x = 1; x <17; x++)
	{
	    IF(flagToggleOutput[x])
	    {
		flagOutput = 1;
	    }
     }

}







(***********************************************************)
(*                STARTUP CODE GOES BELOW                  *)
(***********************************************************)
DEFINE_START


CREATE_BUFFER DEV_Switcher,CMDrx;

(***********************************************************)
(*                THE EVENTS GO BELOW                      *)
(***********************************************************)
DEFINE_EVENT

DATA_EVENT[dvMaster]
{
	ONLINE:
	{
	    SEND_STRING 0,"'online: server'"
	    //IP_CLIENT_OPEN(dvIPClient.Port,'192.168.8.1',nIPPort,TCP_IP)
	}
	OFFLINE:
	{
	    SEND_STRING 0,"'offline: server'"
	}
	COMMAND: 
	{
	}
}

DATA_EVENT[DEV_Switcher]
{
	ONLINE:
	{
	    SEND_COMMAND DEV_Switcher,"'SET_BAUD 19200,N,8,1'"  
	    SEND_COMMAND DEV_Switcher, 'HSOFF';
	    SEND_COMMAND DEV_Switcher, 'XOFF';
	 
	}
	OFFLINE:
	{
	}
	STRING:
	{
	    CMDrx = DATA.TEXT 
	}
	COMMAND: 
	{
	}
}


BUTTON_EVENT[DEV_TP,SWITCHER_ChannelInPuts_BNTS]
{
    PUSH:
    {
	TO[DEV_TP,BUTTON.INPUT.CHANNEL];
	intClear = 0;
	iClear = 0;

	pInput_BNT = GET_LAST(SWITCHER_ChannelInPuts_BNTS);
	getTogleInput(pInput_BNT);
	IF(flagInput) 
	{
	    IF(flagOutput)
	    {
		setCommand (1,pOutput_BNT,pInput_BNT);
	    }
	}
    }
    RELEASE:
    {
    }
}
BUTTON_EVENT[DEV_TP,SWITCHER_ChannelOutPuts_BNTS]
{
    PUSH:
    {
	TO[DEV_TP,BUTTON.INPUT.CHANNEL];
	pOutput_BNT = GET_LAST(SWITCHER_ChannelOutPuts_BNTS);
	
	getTogleOut(pOutput_BNT);	
	IF(flagInput)
	{
		IF(flagOutput)
		{
			setCommand (1,pOutput_BNT,pInput_BNT);
		}
	}
    }
    RELEASE:
    {
    }
}
BUTTON_EVENT[DEV_TP,SWITCHER_ChannelClear_BNT]
{
    PUSH:
    {
	TO[DEV_TP,BUTTON.INPUT.CHANNEL];
	
	intClear =! intClear;
	iClear= intClear;
	flagInput = 0;

	FOR(r= 1; r<16; r++)
	{
	    flagToggleInput[r] = 0;
	    iInput[r] = 0;
	}
	IF(intClear = 1)
	{
		iClear = 1;
	}
	ELSE
	{
		iClear = 0;
	}   

	FOR(r= 1; r<16; r++)
	{
	    flagToggleInput[r] = 0;
	    iInput[r] = 0;
	}
  		IF((flagToggleOutput[1]) ||(flagToggleOutput[2]) ||(flagToggleOutput[3]) ||
		    (flagToggleOutput[4])||(flagToggleOutput[5]) ||(flagToggleOutput[6]) ||
		    (flagToggleOutput[7]) ||(flagToggleOutput[8])||(flagToggleOutput[9]) ||
		    (flagToggleOutput[10]) ||(flagToggleOutput[11]) ||(flagToggleOutput[12])||
		    (flagToggleOutput[13]) ||(flagToggleOutput[14])) 
		{
    		 IF(intClear)
			getBuildString(3,0,0,0);

		}	
    }
    RELEASE:
    {
    }
}
BUTTON_EVENT[DEV_TP,SWITCHER_ChannelPowerOn_BNT]
{
    PUSH:
    {
	TO[DEV_TP,BUTTON.INPUT.CHANNEL];

	FOR(r = 1; r<16; r++)
	{
	    flagToggleInput[r] = 0;
	    iInput[r] = 0;
	}
	buildCMD = getBuildString(2,0,0,1);
	setCommandtx ();
    }
    RELEASE:
    {
    }
}
BUTTON_EVENT[DEV_TP,SWITCHER_ChannelPowerOff_BNT]
{
    PUSH:
    {
	TO[DEV_TP,BUTTON.INPUT.CHANNEL];
	FOR(r = 1; r<16; r++)
	{
	    flagToggleInput[r] = 0;
	    iInput[r] = 0;
	}
	buildCMD = getBuildString(2,0,0,0);
    setCommandtx ();
    }
    RELEASE:
    {
    }
}


(***********************************************************)
(*            THE ACTUAL PROGRAM GOES BELOW                *)
(***********************************************************)
DEFINE_PROGRAM




[DEV_TP,2] = flagToggleInput[1]
[DEV_TP,3] = flagToggleInput[2]
[DEV_TP,4] = flagToggleInput[3]
[DEV_TP,5] = flagToggleInput[4]
[DEV_TP,6] = flagToggleInput[5]
[DEV_TP,7] = flagToggleInput[6]
[DEV_TP,8] = flagToggleInput[7]
[DEV_TP,9] = flagToggleInput[8]
[DEV_TP,10] = flagToggleInput[9]
[DEV_TP,11] = flagToggleInput[10]
[DEV_TP,12] = flagToggleInput[11]
[DEV_TP,13] = flagToggleInput[12]
[DEV_TP,14] = flagToggleInput[13]
[DEV_TP,15] = flagToggleInput[14]
[DEV_TP,16] = flagToggleInput[15]
[DEV_TP,17] = flagToggleInput[16]




[DEV_TP,18] = flagToggleOutput[1]
[DEV_TP,19] = flagToggleOutput[2]
[DEV_TP,20] = flagToggleOutput[3]
[DEV_TP,21] = flagToggleOutput[4]
[DEV_TP,22] = flagToggleOutput[5]
[DEV_TP,23] = flagToggleOutput[6]
[DEV_TP,24] = flagToggleOutput[7]
[DEV_TP,25] = flagToggleOutput[8]
[DEV_TP,26] = flagToggleOutput[9]
[DEV_TP,27] = flagToggleOutput[10]
[DEV_TP,28] = flagToggleOutput[11]
[DEV_TP,29] = flagToggleOutput[12]
[DEV_TP,30] = flagToggleOutput[13]
[DEV_TP,31] = flagToggleOutput[14]
[DEV_TP,32] = flagToggleOutput[15]
[DEV_TP,33] = flagToggleOutput[16]


(***********************************************************)
(*                     END OF PROGRAM                      *)
(*        DO NOT PUT ANY CODE BELOW THIS COMMENT           *)
(***********************************************************)

